(window.webpackJsonp=window.webpackJsonp||[]).push([[10],{1472:function(t,n,e){"use strict";var a=e(36),o=e.n(a),r=e(37),c=e.n(r)()(o.a);c.push([t.i,"\n#emptycontent {\n\tmargin-top: 10vh;\n}\n","",{version:3,sources:["webpack://./src/views/Setup.vue"],names:[],mappings:";AAwEA;CACA,gBAAA;AACA",sourcesContent:["<template>\n\t<Content app-name=\"mail\">\n\t\t<Navigation v-if=\"hasAccounts\" />\n\t\t<div id=\"emptycontent\">\n\t\t\t<div class=\"icon-mail\" />\n\t\t\t<h2>{{ t('mail', 'Connect your mail account') }}</h2>\n\t\t\t<AccountForm :display-name=\"displayName\" :email=\"email\" :save=\"onSave\">\n\t\t\t\t<template v-if=\"error\" #feedback class=\"warning\">\n\t\t\t\t\t{{ error }}\n\t\t\t\t</template>\n\t\t\t</AccountForm>\n\t\t</div>\n\t</Content>\n</template>\n\n<script>\nimport Content from '@nextcloud/vue/dist/Components/Content'\nimport { loadState } from '@nextcloud/initial-state'\nimport { translate as t } from '@nextcloud/l10n'\n\nimport AccountForm from '../components/AccountForm'\nimport Navigation from '../components/Navigation'\nimport logger from '../logger'\n\nexport default {\n\tname: 'Setup',\n\tcomponents: {\n\t\tAccountForm,\n\t\tContent,\n\t\tNavigation,\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tdisplayName: loadState('mail', 'prefill_displayName'),\n\t\t\temail: loadState('mail', 'prefill_email'),\n\t\t\terror: null,\n\t\t}\n\t},\n\tcomputed: {\n\t\thasAccounts() {\n\t\t\treturn this.$store.getters.accounts.length > 1\n\t\t},\n\t},\n\tmethods: {\n\t\tonSave(data) {\n\t\t\tthis.error = null\n\n\t\t\treturn this.$store\n\t\t\t\t.dispatch('createAccount', data)\n\t\t\t\t.then((account) => {\n\t\t\t\t\tlogger.info('account successfully created, redirecting …')\n\t\t\t\t\tthis.$router.push({\n\t\t\t\t\t\tname: 'home',\n\t\t\t\t\t})\n\n\t\t\t\t\treturn account\n\t\t\t\t})\n\t\t\t\t.catch((error) => {\n\t\t\t\t\tlogger.error('Could not create account', { error })\n\n\t\t\t\t\tif (error?.data?.message) {\n\t\t\t\t\t\tthis.error = error.data.message\n\t\t\t\t\t} else {\n\t\t\t\t\t\tthis.error = t('mail', 'Unexpected error during account creation')\n\t\t\t\t\t}\n\t\t\t\t})\n\t\t},\n\t},\n}\n<\/script>\n\n<style>\n#emptycontent {\n\tmargin-top: 10vh;\n}\n</style>\n"],sourceRoot:""}]),n.a=c},1500:function(t,n,e){"use strict";e.r(n);var a=e(892),o=e.n(a),r=e(51),c=e(43),i=e(1173),s=e(1168),l=e(8),m={name:"Setup",components:{AccountForm:i.a,Content:o.a,Navigation:s.a},data:()=>({displayName:Object(r.loadState)("mail","prefill_displayName"),email:Object(r.loadState)("mail","prefill_email"),error:null}),computed:{hasAccounts(){return this.$store.getters.accounts.length>1}},methods:{onSave(t){return this.error=null,this.$store.dispatch("createAccount",t).then(t=>(l.a.info("account successfully created, redirecting …"),this.$router.push({name:"home"}),t)).catch(t=>{var n;l.a.error("Could not create account",{error:t}),null!=t&&null!==(n=t.data)&&void 0!==n&&n.message?this.error=t.data.message:this.error=Object(c.translate)("mail","Unexpected error during account creation")})}}},u=e(35),p=e.n(u),d=e(1472),h={insert:"head",singleton:!1},v=(p()(d.a,h),d.a.locals,e(28)),g=Object(v.a)(m,(function(){var t=this,n=t.$createElement,e=t._self._c||n;return e("Content",{attrs:{"app-name":"mail"}},[t.hasAccounts?e("Navigation"):t._e(),t._v(" "),e("div",{attrs:{id:"emptycontent"}},[e("div",{staticClass:"icon-mail"}),t._v(" "),e("h2",[t._v(t._s(t.t("mail","Connect your mail account")))]),t._v(" "),e("AccountForm",{attrs:{"display-name":t.displayName,email:t.email,save:t.onSave},scopedSlots:t._u([t.error?{key:"feedback",fn:function(){return[t._v("\n\t\t\t\t"+t._s(t.error)+"\n\t\t\t")]},proxy:!0}:null],null,!0)})],1)],1)}),[],!1,null,null,null);n.default=g.exports}},0,[8]]);
//# sourceMappingURL=mail.10.f3236521182c6b558851.js.map